'
' Copyright 2017 Nathan
'
' Licensed under the Apache License, Version 2.0 (the "License"); 
' you may not use this file except in compliance with the License. 
' You may obtain a copy of the License at 
'
' http://www.apache.org/licenses/LICENSE-2.0
'
' Unless required by applicable law or agreed to in writing, software 
' distributed under the License is distributed on an "AS IS" BASIS,
' WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
' See the License for the specific language governing permissions and
' limitations under the License.
'
' 
' experimental tft driver with c-api
' for 28 and 44 pin cpu
'
' Special thanks to 
' Geoff Graham (for the famous Micromite),
' Peter Mather (some parts of the driver are based on his basic driver versions)
' all the others, who made this driver possible.
' 
' This driver ueses CFunRAM memory area range (192)->(255)
'

' please run the following commands after transfer of this file to
' micromite 28 or 44 pin
' cpu 48
' option explicit
' library save

Sub mm.startup
  '  config wntry
  '  XXXXddbiccrrwwrr drv0-2,b->bgrOn, i->is1.44, colAdd 0-3, rowAdd 0-3,
  '                   spi write divider 0-3, spi read divider 0-3
  '                     xxxx dd b i co ro wr rd
  ' ILI9341 red         0000 00 0 0 00 00 01 01 &B000000000101   <- O.K.
  ' ST7735S red         0000 01 0 0 00 00 01 01 &B010000000101   <- O.K.
  ' ST7735S black       0000 01 1 0 00 00 01 01 &B011000000101   <- untested
  ' ST7735S green       0000 01 0 0 10 01 01 01 &B010010010101   <- untested
  ' ST7735S green 1.44  0000 01 0 1 10 11 01 01 &B010110110101   <- untested
  ' dispDriverSPI_SI CD, RST, CS, config, orientation            <- single display
  ' dispDriverSPI_SI CD, RST, CS1, config1, orientation1, CS2, config2, orientation2 <- dual display
  
  ' example ili9341 spi speed read 2, write 1 
  ' dispDriverSPI_SI 26, 27,31,&B000000000110,1

  ' example ST7735 red label, spi speed read 2, write 1 
  dispDriverSPI_SI 26, 27, 22, &B010000000110, 1
  
  ' example dual display CD, RST are same for both displays
  ' Two different CS chip selects are required 
  ' dispDriverSPI_SI 26, 27,31,&B000000000110,1,22,&B010000000110, 1
End Sub

CSub dispDriverSPI_SI
    000007AC
    'getFPC
    27BDFFF8 AFBF0004 00852023 03E42021 ACC40000 8FBF0004 03E00008 27BD0008 
    'trialSync
    27BDFFC0 AFBF003C AFBE0038 AFB70034 AFB60030 AFB5002C AFB40028 AFB30024 
    AFB20020 AFB1001C AFB00018 7C042620 30DE00FF 3C029D00 8C42008C 245400D8 
    245200C0 8E83000C 30630003 00033080 00031900 00661823 02439021 8E460008 
    3C030C00 00C31824 14600068 7C052E20 3C039D00 8C630090 90630015 7CC70C00 
    3C06BF80 ACC75830 8C5600D8 24020001 10620006 8E550000 24020003 14620005 
    7C051620 10000002 00802821 00802821 7C051620 04420001 00002821 7C051620 
    28440140 50800001 00001021 2463FFFD 306300FF 2C630002 10600004 96510008 
    24030258 00621023 7C021620 00511021 3051FFFF 2E220141 14400030 00009821 
    2631FEC0 3231FFFF 2E220141 5040FFFD 2631FEC0 10000029 00009821 AEA20000 
    00000040 96820008 AEC20000 00000040 24020045 AE025820 8E025810 30420080 
    1040FFFD 00000000 8E025820 96820008 AEC20004 8EE20004 0040F809 24040008 
    AE005820 8E025810 30420080 1040FFFD 00000000 8E045820 AE005820 00042200 
    3084FFFF 8E025810 30420080 1040FFFD 00000000 8E035820 00831025 96430004 
    AEA30004 00021040 17C00012 304203FE 26730001 10000006 3273FFFF 24020320 
    26230005 AFA30010 3C10BF80 3C179D00 0222182B 10600005 24031389 8FA40010 
    0044182A 14600003 24031389 5663FFCB 96420004 8E440008 7C840C80 3C03BF80 
    AC645830 10000002 7C021620 2402FFFF 8FBF003C 8FBE0038 8FB70034 8FB60030 
    8FB5002C 8FB40028 8FB30024 8FB20020 8FB1001C 8FB00018 03E00008 27BD0040 
    'setIoCfg
    27BDFFE0 AFBF001C AFB20018 AFB10014 AFB00010 7C048420 7C069420 3C119D00 
    8E220010 02002021 7C052C20 0040F809 00003021 8E220010 02002021 24050065 
    0040F809 00003021 1A400005 3C029D00 8C42001C 02002021 0040F809 02402821 
    8FBF001C 8FB20018 8FB10014 8FB00010 03E00008 27BD0020 
    'writeConfSpi
    27BDFFB8 AFBF0044 AFBE0040 AFB7003C AFB60038 AFB50034 AFB40030 AFB3002C 
    AFB20028 AFB10024 AFB00020 0080B021 00852821 AFA50018 3C029D00 8C430090 
    AFA30014 8C43008C 247200C0 8C6300E4 30630003 00032080 00031900 00641823 
    02439021 8C42001C 8FA30014 8064002D 0040F809 24050005 8FA40018 02C4102B 
    1040006E 3C03BF80 3C10BF80 3C1E9D00 24140001 3C150200 24170036 8E025810 
    30420080 1040FFFD 8FA30014 92D10001 8FC2001C 8064002C 0040F809 24050005 
    AE115820 92D30000 00132102 3273000F 2E62000E 14400002 AFA40010 26730001 
    26D60002 8E025810 30420080 1040FFFD 8FA30014 8FC2001C 8064002C 0040F809 
    24050006 12600033 02C02021 00001821 2409002A 2408002B 24070003 3C0A0100 
    8E460008 00D51024 10400003 00002821 52370001 24050008 10740003 00000000 
    1467000A 00000000 16290004 00000000 8E450008 10000005 7CA50D80 16280003 
    00000000 8E450008 7CA50D00 8E025810 30420080 1040FFFD 00000000 5467000A 
    90820000 56280008 90820000 00CA3024 50C00005 90820000 24A5007F AE055820 
    10000004 24840001 00A22821 AE055820 24840001 24630001 306300FF 5473FFD9 
    8E460008 2662FFFF 304200FF 24420001 02C2B021 8FA40010 50800015 8FA30018 
    1094000A 00041080 000419C0 00621023 00441021 00022080 00441021 00022080 
    00442021 10000002 00042100 24042710 8E025810 30420080 1040FFFD 00000000 
    8FC20004 0040F809 00000000 8FA30018 02C3102B 1440FF99 3C03BF80 8C625810 
    30420080 1040FFFD 3C029D00 8C42001C 8FA30014 8064002D 0040F809 24050006 
    8FBF0044 8FBE0040 8FB7003C 8FB60038 8FB50034 8FB40030 8FB3002C 8FB20028 
    8FB10024 8FB00020 03E00008 27BD0048 
    'DefineRegion
    27BDFFD0 AFBF002C AFB60028 AFB50024 AFB40020 AFB3001C AFB20018 AFB10014 
    AFB00010 00808821 00A09021 00C09821 00E0A021 3C029D00 8C43008C 247000C0 
    8C6300E4 30630003 00032080 00031900 00641823 02038021 8C550090 8C42001C 
    82A4002C 0040F809 24050005 2403002A 3C02BF80 AC435820 0233102A 14400003 
    02201021 02608821 00409821 06600005 24160001 06200006 0000B021 10000006 
    3C029D00 00009821 10000002 00008821 00008821 3C029D00 8C420094 8C420000 
    0222182B 14600005 0262182B 2451FFFF 02209821 10000003 24160001 50600001 
    2453FFFF 3C03BF80 8C625810 30420080 1040FFFD 3C029D00 8C42001C 82A4002C 
    0040F809 24050006 8E020008 7C420D80 02228821 00111A03 3C02BF80 AC435820 
    0254102A 14400004 3C03BF80 02401021 02809021 0040A021 8C625810 30420002 
    1440FFFD 3C02BF80 AC515820 06820005 24160001 06430006 8E020008 10000003 
    00009021 0000A021 00009021 8E020008 7C420D80 02629821 3C03BF80 8C625810 
    30420002 1440FFFD 3C02BF80 00131A03 AC435820 3C029D00 8C420098 8C420000 
    0242182B 14600005 0282182B 2452FFFF 0240A021 10000003 24160001 50600001 
    2454FFFF 3C03BF80 8C625810 30420002 1440FFFD 3C02BF80 AC535820 3C03BF80 
    8C625810 30420080 1040FFFD 3C029D00 8C42001C 82A4002C 0040F809 24050005 
    2403002B 3C02BF80 AC435820 3C03BF80 8C625810 30420080 1040FFFD 3C029D00 
    8C42001C 82A4002C 0040F809 24050006 8E020008 7C420D00 02429021 00121A03 
    3C02BF80 AC435820 3C03BF80 8C625810 30420002 1440FFFD 3C02BF80 AC525820 
    8E020008 7C420D00 0282A021 3C03BF80 8C625810 30420002 1440FFFD 3C02BF80 
    00141A03 AC435820 3C03BF80 8C625810 30420002 1440FFFD 3C02BF80 AC545820 
    56C00006 00001021 26730001 02718823 26940001 02929023 72511002 8FBF002C 
    8FB60028 8FB50024 8FB40020 8FB3001C 8FB20018 8FB10014 8FB00010 03E00008 
    27BD0030 
    'DrawRectangleSPI
    27BDFFC8 AFBF0034 AFB70030 AFB6002C AFB50028 AFB40024 AFB30020 AFB2001C 
    AFB10018 AFB00014 8FB20048 3C02BF80 8C575800 8C555830 8C565840 3C039D00 
    8C63008C 247100D8 247000C0 8E28000C 31080003 00084880 00084100 01094023 
    02088021 8C7300D8 8E140000 AC405800 8E030008 7C630C80 AC435830 24030C00 
    AC435840 3C030001 34638060 AC435800 96020004 AE820000 0411FF20 00000000 
    3C04BF80 8C835810 30630080 1060FFFD 00000000 96230008 AE630000 2404002C 
    3C03BF80 AC645820 7E451340 00122403 2403FFF8 00831824 00A32825 30A500FF 
    7E4620C0 00129143 2403FFE0 02439024 00D23025 30C600FF 3C04BF80 8C835810 
    30630080 1060FFFD 00000000 96230008 AE630004 1040000E 2442FFFF 3C03BF80 
    8C645810 30840002 1480FFFD 00000000 AC655820 8C645810 30840002 1480FFFD 
    00000000 AC665820 1440FFF5 2442FFFF 3C03BF80 8C625810 30420080 1040FFFD 
    00000000 96020004 AE820004 3C02BF80 AC405800 8C435820 24040040 3C03BF80 
    AC645814 AC555830 AC565840 AC575800 8FBF0034 8FB70030 8FB6002C 8FB50028 
    8FB40024 8FB30020 8FB2001C 8FB10018 8FB00014 03E00008 27BD0038 
    'readVideoRam
    27BDFFD0 AFBF002C AFB50028 AFB40024 AFB30020 AFB2001C AFB10018 AFB00014 
    0080A021 108000B8 00A09021 3C029D00 8C43008C 247300C0 8C6300E4 30630003 
    00032080 00031900 00641823 02639821 8E630008 7C700E80 8C510090 7C630C00 
    3C15BF80 AEA35830 8C42001C 8224002C 0040F809 24050005 2402003A AEA25820 
    3C03BF80 8C625810 30420080 1040FFFD 3C029D00 8C42001C 8224002C 0040F809 
    24050006 24030066 3C02BF80 AC435820 3C03BF80 8C625810 30420080 1040FFFD 
    3C029D00 8C42001C 8224002C 0040F809 24050005 2403002E 3C02BF80 AC435820 
    3C03BF80 8C625810 30420080 1040FFFD 00000000 12000010 3C029D00 3C15BF80 
    24021000 AEA25808 3C029D00 8C42001C 8224002C 0040F809 24050006 AEA05820 
    3C02BF81 8C43FA84 7C031804 AC43FA84 10000008 3C03BF80 8C42001C 8224002C 
    0040F809 24050006 3C02BF80 AC405820 3C03BF80 8C625810 30420080 1040FFFD 
    3C02BF80 8C425810 30420020 14400006 3C02BF80 8C435820 8C435810 30630020 
    1060FFFC 00000000 00002021 3C02BF80 2409FFF8 2408FFE0 AC405820 AC405820 
    8C435810 30630080 1060FFFD 00000000 AC405820 8C455820 30A500FF 8C435820 
    12000005 306300FF 00052840 30A500FF 00031840 306300FF 02803021 00033942 
    00A92824 00E52825 A2850000 000338C0 30E700FF 00E83824 8C435810 30630080 
    1060FFFD 00000000 8C455820 12000003 30A500FF 00052840 30A500FF 000528C2 
    00E52825 A0C50001 24840002 0092182B 1460FFD9 26940002 3C029D00 8C42001C 
    8224002D 0040F809 24050006 1200000A 3C02BF81 8C43FA84 24040001 7C831804 
    AC43FA84 24031000 3C02BF80 AC435804 10000006 3C109D00 00000040 00000040 
    00000040 00000040 3C109D00 8E02001C 8224002D 0040F809 24050005 8E02001C 
    8224002C 0040F809 24050005 2403003A 3C02BF80 AC435820 3C03BF80 8C625810 
    30420080 1040FFFD 3C029D00 8C42001C 8224002C 0040F809 24050006 24030055 
    3C02BF80 AC435820 3C03BF80 8C625810 30420080 1040FFFD 3C02BF80 8E630008 
    7C630C80 AC435830 8FBF002C 8FB50028 8FB40024 8FB30020 8FB2001C 8FB10018 
    8FB00014 03E00008 27BD0030 
    'DrawBitmapSPI
    27BDFFA0 AFBF005C AFBE0058 AFB70054 AFB60050 AFB5004C AFB40048 AFB30044 
    AFB20040 AFB1003C AFB00038 0080B021 AFA50064 00C09021 AFA7006C 8FB00070 
    8FB40074 8FB50078 8FB3007C 3C02BF80 8C435800 AFA30028 8C455830 AFA5002C 
    8C475840 AFA70030 3C039D00 8C64008C 8C8600E4 30C60003 2405000C 70C53802 
    00E42021 8C650090 AFA5001C AC405800 8C8400C8 7C840C80 AC445830 24040C00 
    AC445840 3C040001 34848260 AC445800 8C62001C 80A4002D 0040F809 24050005 
    26C6FFFF 8FA20064 2447FFFF 02C02021 00402821 72121002 00463021 8FA2006C 
    72021802 00673821 0411FDD2 00000000 0040F021 3C02BF80 8C435810 30630080 
    1060FFFD 00000000 13C00018 00008821 24020001 52820004 3202FFFF 56A20014 
    3C029D00 3202FFFF 0012B840 8FA3006C 72E3B802 7057B802 70571002 3057FFFF 
    3C029D00 8C42003C 0040F809 26E40001 00408821 00402021 02E02821 0411FEDD 
    00000000 10000002 3C029D00 3C029D00 8C42001C 8FA3001C 8064002C 0040F809 
    24050005 2403002C 3C02BF80 AC435820 8C435810 30630080 1060FFFD 00000000 
    3C029D00 8C42001C 8FA5001C 80A4002C 0040F809 24050006 13C00090 8FA7006C 
    18E0008E 00141403 7E9E1340 2403FFF8 00431024 03C2F025 33DE00FF 7E9720C0 
    00142143 2402FFE0 00822024 02E4B825 32F700FF 7EBF1340 00152403 00831824 
    03E3F825 33FF00FF 7EB920C0 00151943 00621024 0322C825 333900FF 0200C021 
    8FA20064 AFA20014 00121823 AFA30024 70F21002 2442FFFF AFA20010 AFB20034 
    00007821 00005021 AFA00020 240E0001 3C069D00 3C04BF80 AFB60018 1A000058 
    8FA20014 0302B021 00403821 5A400052 24E70001 8FAB0018 8FA80010 00004821 
    012F1021 24430007 284D0000 006D100B 000268C3 026D6821 000817C3 00021742 
    01026021 318C0007 01826023 018E6004 01601021 00001821 04420038 24630001 
    8CC50094 8CA50000 0045282B 50A00033 24630001 04E20031 24630001 8CC50098 
    8CA50000 00E5282B 50A0002C 24630001 91A50000 00AC2824 10A00015 00000000 
    12200007 00000000 568E0005 254A0002 022A2821 90BE0000 90B70001 254A0002 
    8C855810 30A50002 14A0FFFD 00000000 AC9E5820 8C855810 30A50002 14A0FFFD 
    00000000 AC975820 10000014 24630001 12200007 00000000 56AE0005 254A0002 
    022A2821 90BF0000 90B90001 254A0002 8C855810 30A50002 14A0FFFD 00000000 
    AC9F5820 8C855810 30A50002 14A0FFFD 00000000 AC995820 24630001 1470FFC6 
    24420001 25290001 2508FFFF 1532FFB4 01785821 24E70001 14F6FFAC 00000000 
    8FA30020 24630001 AFA30020 8FA50014 00B82821 AFA50014 8FA70010 8FA20024 
    00E23821 AFA70010 8FA30034 8FA50020 8FA7006C 14A7FF99 01E37821 12200004 
    3C029D00 8C420044 0040F809 02202021 3C02BF80 8C435810 30630080 1060FFFD 
    8FA3001C 3C029D00 8C42001C 8064002D 0040F809 24050006 3C02BF80 AC405800 
    8C435820 24040040 3C03BF80 AC645814 8FA5002C AC455830 8FA70030 AC475840 
    8FA30028 AC435800 8FBF005C 8FBE0058 8FB70054 8FB60050 8FB5004C 8FB40048 
    8FB30044 8FB20040 8FB1003C 8FB00038 03E00008 27BD0060 
    'writeVideoRamRGB
    27BDFFD8 AFBF0024 AFB30020 AFB2001C AFB10018 AFB00014 00809821 30B2FFFF 
    3C109D00 8E110090 8E02001C 8224002D 0040F809 24050005 8E02001C 8224002C 
    0040F809 24050006 2E420100 54400001 26730001 24020003 0242001B 004001F4 
    00009012 3242FFFF 1040001F 2442FFFF 3042FFFF 00024040 01021021 02624021 
    2407FFF8 3C02BF80 2406FFE0 92650000 00E52824 92640001 00041942 00A32825 
    8C435810 30630002 1460FFFD 00000000 AC455820 000420C0 00862024 92630002 
    000318C2 00832025 308400FF 8C435810 30630002 1460FFFD 00000000 AC445820 
    1668FFEA 26730003 3C03BF80 8C625810 30420080 1040FFFD 3C029D00 8C42001C 
    8224002D 0040F809 24050006 8FBF0024 8FB30020 8FB2001C 8FB10018 8FB00014 
    03E00008 27BD0028 
    'writeVideoRam
    27BDFFB8 AFBF0044 AFBE0040 AFB7003C AFB60038 AFB50034 AFB40030 AFB3002C 
    AFB20028 AFB10024 AFB00020 00808821 00A09821 30C6FFFF AFA60010 7C07B620 
    87B70058 87A2005C AFA20014 87A30060 AFA30018 3C029D00 8C5E0090 3C03BF80 
    AC605800 24050040 3C04BF80 AC855814 3C040001 34848260 AC645800 8C42001C 
    83C4002D 0040F809 24050005 02C09021 8FB00014 02E0A821 8FB40018 26C6FFFF 
    26E7FFFF 02C02021 02E02821 00D03021 00F43821 0411FC6F 00000000 3056FFFF 
    3C03BF80 8C625810 30420080 1040FFFD 00000000 12C0000F 8FB70010 1260000D 
    8FA30010 30620001 1040000B 32E20008 02602021 00162840 0411FD86 00000000 
    8FA30010 30620002 54400001 0000B021 8FB70010 32E20008 54400001 00009821 
    3C029D00 8C42001C 83C4002C 0040F809 24050005 2403002C 3C02BF80 AC435820 
    3C03BF80 8C625810 30420080 1040FFFD 3C029D00 8C42001C 83C4002C 0040F809 
    24050006 12C00046 3C03BF80 1E80003A 00005821 10000042 00000000 00001021 
    01755821 56E00006 00003821 02253021 90CC0000 90C70001 10000002 24A50002 
    00006021 00721821 04620020 24420001 8D060094 8CC60000 0066182B 5060001B 
    24420001 05620019 24420001 8D030098 8C630000 0163182B 50600014 24420001 
    12600007 00EC1825 54600005 254A0002 026A1821 906C0000 90670001 254A0002 
    8C835810 30630002 1460FFFD 00000000 AC8C5820 8C835810 30630002 1460FFFD 
    00000000 AC875820 24420001 3042FFFF 0050302A 14C0FFD3 00401821 25290001 
    3129FFFF 0134102A 14400009 01205821 1000000B 3C03BF80 00004821 00002821 
    00005021 32F70004 3C089D00 3C04BF80 5E00FFC2 00001821 1000FFF1 25290001 
    8C625810 30420080 1040FFFD 3C029D00 8C42001C 83C4002D 0040F809 24050006 
    8FBF0044 8FBE0040 8FB7003C 8FB60038 8FB50034 8FB40030 8FB3002C 8FB20028 
    8FB10024 8FB00020 03E00008 27BD0048 
    'videoRamFunc
    27BDFFD8 AFBF0024 308400FF 30E2FFFF 87A70038 87AA003C 87A90040 24030001 
    1083000D 87A80044 50800006 00A02021 24030002 14830016 8FBF0024 10000010 
    00A02021 00402821 0411FEEF 00000000 1000000F 8FBF0024 AFAA0010 AFA90014 
    AFA80018 00A02021 00C02821 00403021 0411FF2F 00000000 10000005 8FBF0024 
    00402821 0411FCEF 00000000 8FBF0024 03E00008 27BD0028 
    'setOri
    27BDFFE0 AFBF001C AFB00018 309000FF 00002021 3C059D00 24A51684 27A60010 
    0411FA60 00000000 2602FFFF 304200FF 2C420004 50400001 24100001 3C029D00 
    8C43008C 8C6400E4 30840003 00042880 00042100 00852023 00641821 8C420090 
    A0500015 8C6200C8 3C030C00 00431824 10600008 240500F0 26100004 7C420600 
    14400006 321000FF 24050080 10000005 240300A0 10000003 24030140 24050080 
    24030080 8FA60010 2602FFFF 00022040 00821021 00461021 3C049D00 248421A0 
    32100001 12000007 00822021 3C029D00 8C460098 ACC50000 8C420094 10000006 
    AC430000 3C029D00 8C460094 ACC50000 8C420098 AC430000 24050003 0411FADF 
    00000000 8FBF001C 8FB00018 03E00008 27BD0020 
    'videoBaseFunc
    27BDFFD8 AFBF0024 AFB40020 AFB3001C AFB20018 AFB10014 AFB00010 00A08021 
    00C08821 00E09021 8FB40038 8FA2003C 308400FF 3C039D00 8C65008C 8CA600E4 
    8C730090 24030005 10830097 30C60003 2C830006 50600011 24020007 24030002 
    1083002E 2C830003 50600006 24020003 24030001 548300B0 00008021 10000012 
    3C03BF80 10820033 24020004 548200AA 00008021 1000005A 3C029D00 10820094 
    2C820007 5440008C 86040000 24020008 10820094 24020009 5482009F 00008021 
    10000097 00000000 8C645800 AC440000 8C645830 AC440004 8C645840 AC440008 
    AC605800 00061080 00063100 00C23023 00A62821 8CA200C8 7C420C80 AC625830 
    24020C00 AC625840 3C020001 34428260 AC625800 10000088 00008021 3C03BF80 
    AC605800 8C645820 24050040 3C04BF80 AC855814 8C440004 AC645830 8C440008 
    AC645840 8C420000 AC625800 1000007A 00008021 3C029D00 8C42001C 8264002D 
    0040F809 24050005 8E040000 8E250000 2486FFFF 8E430000 24A7FFFF 8E820000 
    00C33021 00E23821 0411FB1B 00000000 3050FFFF 3C03BF80 8C625810 30420080 
    1040FFFD 3C029D00 8C42001C 8264002C 0040F809 24050005 2403002C 3C02BF80 
    AC435820 3C03BF80 8C625810 30420080 1040FFFD 3C119D00 8E22001C 8264002C 
    0040F809 24050006 8E22001C 8264002D 0040F809 24050006 10000050 02001021 
    8C42001C 8264002D 0040F809 24050005 8E040000 8E250000 2486FFFF 8E430000 
    24A7FFFF 8E820000 00C33021 00E23821 0411FAF1 00000000 3050FFFF 3C03BF80 
    8C625810 30420080 1040FFFD 3C029D00 8C42001C 8264002C 0040F809 24050005 
    2403002E 3C02BF80 AC435820 3C03BF80 8C625810 30420080 1040FFFD 3C119D00 
    8E22001C 8264002C 0040F809 24050006 8E22001C 8264002D 0040F809 24050006 
    10000026 02001021 8E040000 8E250000 2486FFFF 8CE30000 24A7FFFF 8E820000 
    00C33021 00E23821 0411FACB 00000000 10000019 3050FFFF 86250000 00003021 
    0411F973 00000000 10000013 00008021 92040000 0411FEFD 00000000 1000000E 
    00008021 86040000 86250000 24060001 0411F967 00000000 10000007 3050FFFF 
    12000004 24020003 AE020000 10000002 24100101 24100101 02001021 8FBF0024 
    8FB40020 8FB3001C 8FB20018 8FB10014 8FB00010 03E00008 27BD0028 
    'driverInit
    27BDFFB8 AFBF0044 AFB70040 AFB6003C AFB50038 AFB40034 AFB30030 AFB2002C 
    AFB10028 AFB00024 00002021 3C059D00 24A51B0C 27A60018 0411F93E 00000000 
    3C02BF80 8C575800 8C555830 8C565840 3C109D00 8E120090 8E13008C 267400D8 
    267100C0 8E6200E4 30420003 00021880 00021100 00431023 02228821 8E020024 
    8244002C 0040F809 24050005 AE6200D8 8E020028 0040F809 8244002C 24130001 
    00531004 A6820008 8E020024 8244002D 0040F809 24050005 AE220000 8E020028 
    0040F809 8244002D 00531004 A6220004 8E230008 3C020C00 00621024 54400009 
    A6200008 24020028 A6220008 8FA20018 3C109D00 26102124 02028021 10000006 
    2413007A 8FA20018 3C109D00 261020B8 02028021 2413006C 3C02BF81 8C43F220 
    7C63D800 3C020661 3442A053 10620009 3C02BF81 8C43F220 7C63D800 3C020660 
    3442A053 54620004 2404000C 10000002 24040050 24040050 3C039D00 8C620088 
    00821021 8C430000 24020065 10620054 3C02BF81 8C43F220 7C63D800 3C020661 
    3442A053 10620009 3C02BF81 8C43F220 7C63D800 3C020660 3442A053 54620004 
    24040003 10000002 24040014 24040014 24050002 2406FFFF 0411F976 00000000 
    3C02BF81 8C43F220 7C63D800 3C020661 3442A053 10620009 3C02BF81 8C43F220 
    7C63D800 3C020660 3442A053 54620004 2404000E 10000002 24040029 24040029 
    24050002 2406FFFF 0411F962 00000000 3C02BF81 8C43F220 7C63D800 3C020661 
    3442A053 10620009 3C02BF81 8C43F220 7C63D800 3C020660 3442A053 54620004 
    24040019 10000002 2404000E 2404000E 24050008 2406FFFF 0411F94E 00000000 
    3C02BF81 8C43FA84 24040001 7C831804 AC43FA84 3C02BF81 8C43FB04 24040003 
    7C831804 AC43FB04 3C02BF80 AC405800 8E230008 7C630C80 AC435830 24030C00 
    AC435840 34038060 AC435800 8C555830 8C575800 8C565840 1000000B 02002021 
    3C02BF80 AC405800 8E230008 7C630C80 AC435830 24030C00 AC435840 34038060 
    AC435800 02002021 02602821 0411F947 00000000 8FA40018 3C109D00 8E020048 
    3C039D00 2463084C 00641821 AC430000 8FA40018 8E02004C 3C039D00 24630D34 
    00641821 AC430000 8FA40018 8E02008C 3C039D00 24631770 00641821 AC4300FC 
    8FA40018 8E02008C 3C039D00 246315C4 00641821 AC4300F8 92440015 0411FE0C 
    00000000 3C02BF80 AC405800 8C435820 24040040 3C03BF80 AC645814 AC555830 
    AC565840 AC575800 8E020048 8E030094 8C660000 8E030098 8C670000 AFA00010 
    8C420000 00002021 00002821 24C6FFFF 0040F809 24E7FFFF 8FBF0044 8FB70040 
    8FB6003C 8FB50038 8FB40034 8FB30030 8FB2002C 8FB10028 8FB00024 03E00008 
    27BD0048 
    'main
    27BDFFD0 AFBF002C AFB60028 AFB50024 AFB40020 AFB3001C AFB20018 AFB10014 
    AFB00010 00C09021 8FB60040 8FB50044 8FB3004C 3C029D00 8C54008C 269000C0 
    8C510090 94E30000 A603000A 92C30000 A2030007 90C30000 A2030006 80A30000 
    A223002E 90840000 A224002C 8C420088 00032080 00821021 8C440000 24020065 
    1082000B 269400D8 00602021 24050008 24060006 0411F8C6 00000000 8224002C 
    24050008 24060006 0411F8C1 00000000 82440000 3C029D00 8C420088 00041880 
    00621021 8C430000 24020065 10620004 24050008 24060006 0411F8B5 00000000 
    1260001C 8FA20048 94420000 A6020016 92620000 A2020013 92A20000 A2020012 
    8E82000C 24030001 7C621884 7C620804 AE82000C 92A20000 A222002D 92620000 
    A2220015 82A40000 3C029D00 8C420088 00041880 00621021 8C430000 24020065 
    10620004 24050008 24060006 0411F898 00000000 3C109D00 8E02001C 8224002E 
    0040F809 24050006 8E020004 0040F809 24042710 8E02001C 8224002E 0040F809 
    24050005 8E020004 0040F809 24042710 8E02001C 8224002E 0040F809 24050006 
    8E020004 0040F809 24042710 52600004 92420000 0411FE99 00000000 92420000 
    A222002D 92C20000 A2220015 8E82000C 7C020804 AE82000C 0411FE90 00000000 
    8FBF002C 8FB60028 8FB50024 8FB40020 8FB3001C 8FB20018 8FB10014 8FB00010 
    03E00008 27BD0030 
    '.rodata
    '_initDataST
    11A00130 2C01B103 01B2032D B3062D2C 012D2C01 B4012D2C A2C00307 C1018402 
    0AC202C5 8AC30200 8AC4022A 0EC501EE 36012000 053A01C0 00002A04 2B047F00 
    9F000000 1C02E00F 32371207 29252D29 0100392B E10F1003 06071D03 2D292C2E 
    3F372E2E 10020000 29001310 
    '_initDataILI
    28000120 8300CF03 64ED0430 03811203 790185E8 2C39CB05 01023400 EA0220F7 
    C0010000 11C10126 3E35C502 01BEC701 3A014836 00B10255 08F2011B 0E012601 
    181A1FE0 45060F0A 070A3287 00050702 2500E10E 09100527 054D783A 3A380D18 
    002A041F 04EF0000 0100002B 07B7013F 820AB604 11200027 00002920 
    '_initDataOri
    01283601 36014836 883601E8 01A03601 3601C036 00360160 
End CSub
 
 
 
